/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.parsing;

import beaver.Parser;
import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.build.IProblem;
import com.aptana.js.core.parsing.JSFlexScanner;
import com.aptana.js.core.parsing.JSInsertionRecoveryStrategy;
import com.aptana.js.core.parsing.JSParseState;
import com.aptana.js.core.parsing.JSTokenType;
import com.aptana.js.core.parsing.Messages;
import com.aptana.js.core.parsing.ast.JSArgumentsNode;
import com.aptana.js.core.parsing.ast.JSArrayNode;
import com.aptana.js.core.parsing.ast.JSAssignmentNode;
import com.aptana.js.core.parsing.ast.JSBinaryArithmeticOperatorNode;
import com.aptana.js.core.parsing.ast.JSBinaryBooleanOperatorNode;
import com.aptana.js.core.parsing.ast.JSBreakNode;
import com.aptana.js.core.parsing.ast.JSCaseNode;
import com.aptana.js.core.parsing.ast.JSCatchNode;
import com.aptana.js.core.parsing.ast.JSCommaNode;
import com.aptana.js.core.parsing.ast.JSCommentNode;
import com.aptana.js.core.parsing.ast.JSConditionalNode;
import com.aptana.js.core.parsing.ast.JSConstructNode;
import com.aptana.js.core.parsing.ast.JSContinueNode;
import com.aptana.js.core.parsing.ast.JSDeclarationNode;
import com.aptana.js.core.parsing.ast.JSDefaultNode;
import com.aptana.js.core.parsing.ast.JSDoNode;
import com.aptana.js.core.parsing.ast.JSElementsNode;
import com.aptana.js.core.parsing.ast.JSElisionNode;
import com.aptana.js.core.parsing.ast.JSEmptyNode;
import com.aptana.js.core.parsing.ast.JSErrorNode;
import com.aptana.js.core.parsing.ast.JSFalseNode;
import com.aptana.js.core.parsing.ast.JSFinallyNode;
import com.aptana.js.core.parsing.ast.JSForInNode;
import com.aptana.js.core.parsing.ast.JSForNode;
import com.aptana.js.core.parsing.ast.JSFunctionNode;
import com.aptana.js.core.parsing.ast.JSGetElementNode;
import com.aptana.js.core.parsing.ast.JSGetPropertyNode;
import com.aptana.js.core.parsing.ast.JSGroupNode;
import com.aptana.js.core.parsing.ast.JSIdentifierNode;
import com.aptana.js.core.parsing.ast.JSIfNode;
import com.aptana.js.core.parsing.ast.JSInvokeNode;
import com.aptana.js.core.parsing.ast.JSLabelledNode;
import com.aptana.js.core.parsing.ast.JSNameValuePairNode;
import com.aptana.js.core.parsing.ast.JSNode;
import com.aptana.js.core.parsing.ast.JSNullNode;
import com.aptana.js.core.parsing.ast.JSNumberNode;
import com.aptana.js.core.parsing.ast.JSObjectNode;
import com.aptana.js.core.parsing.ast.JSParametersNode;
import com.aptana.js.core.parsing.ast.JSParseRootNode;
import com.aptana.js.core.parsing.ast.JSPostUnaryOperatorNode;
import com.aptana.js.core.parsing.ast.JSPreUnaryOperatorNode;
import com.aptana.js.core.parsing.ast.JSRegexNode;
import com.aptana.js.core.parsing.ast.JSReturnNode;
import com.aptana.js.core.parsing.ast.JSStatementsNode;
import com.aptana.js.core.parsing.ast.JSStringNode;
import com.aptana.js.core.parsing.ast.JSSwitchNode;
import com.aptana.js.core.parsing.ast.JSThisNode;
import com.aptana.js.core.parsing.ast.JSThrowNode;
import com.aptana.js.core.parsing.ast.JSTrueNode;
import com.aptana.js.core.parsing.ast.JSTryNode;
import com.aptana.js.core.parsing.ast.JSVarNode;
import com.aptana.js.core.parsing.ast.JSWhileNode;
import com.aptana.js.core.parsing.ast.JSWithNode;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParser;
import com.aptana.parsing.IRecoveryStrategy;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseError;
import com.aptana.parsing.util.ParseUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;

public class JSParser
extends Parser
implements IParser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9pjNGTy55KJdzdBfLw08264q4CIge28OY4YdG3I554GmT2as501GOeY7QI92e9qYFJUaQuWOiUElVU6gBZl##$kozrUSdUv1eVVR$T#i$FAlFdFcvtNDiT1b9L7Rz67D9GIwMQwaRfHTxgTUf63Eb8kzQ7twGDQIQieZvvJkjCm6Wx9tjINkb0dwa5TgH$TG6teDkf9Tr0IbQJET2krfLje0Ksa3dGJjQCKQa$zwKuQG0Df40sck#XkkeVkfVje2DrF3z234Z$L3J#kCBv4Z$UAdqO9Jlp5N5BYboyItz1RqOolv9hmZNhzhWoWPA$uERGZ7vzBYxCIlxAV#9#vzJ$TG$$pkJVy8tJOsV$Mua#9x$0JFzkCpvTB$8BOjUbIh$WPjCY9$p4zA$6p$CHFSiC$A$6DkXoAfVrqW0xgVVI6VxNB$pIQHWNe$nItvzzFuhz0Bz8nYMsat$EAVufdEl6pQRw1ptNyn7$8xVdFSEk$#JxJ6putuiOc$7za$rEBmbSo#7T#a9waftWwpQNPz9YMfXfqFOsdH#XHQiXRwJXTHTNfA1tY5mnly6$yAq$YyVmeZ#67kGktuFxSWn$YeJo4#$1Vz0LzoV#ooeA#fUyKHR4fKKeqtyRJU2etfpynMi$nFtnE8OND5l2BV8oFyqjyWdRmQxo3D$CMarMLgQLXbT8tL0kKxag29mi2yG6f8VbWafBebm#sctt0O$aUmog#3pw83yc2AKfgq3xGnmCiA16I1VkKYaNuOBBkWvEyXI$3fmRNubayYtRHRjf3UwayBAWSaWNBbAeX#w1gY3x8Ai875NKVl8euCEOYOox8zq4wB9WVaWKPIerGnm8$6v85MSgbHVZWRTq7xy07XMV5R8w21Kj2cWzkK#hvxmEgvUO3tGfOi38a7xoZN5643x9vbxF7SQ1Ae6hKY2#ZANmflGiBdWl9We#KguBr0MpuXEl2WdKXpaYDVFfWJn6sPCA2ZI5PyAdIE6WVjEHMuYfOy4585anKMlZmmRuYBQaA2puAoOA$bDR1#O2Uf#sqWih1Wiz2ik1VfLqe5l1mMF1bA1OmAns2ZeDR#6PMOC5t8LbWLsxo6WVx$V145LZmSqWMn2Ytvbl0LIWwmATGWHrafoZl5j3ZcWNq5NrDtsWMqFVq0$r8FvlYmD#8cqDbpHOgtR07VfdByNLy2OtGFdmDboA5cj49$HIHJTTG4sgYpW$PmfsSGljmHjd9PMWVr#CAt513u0LkzlIdLlXaSstCazaybxALRfpfNC4bvpjeMgZsS3ht3lnPyKYoXUo9R9uN639MpcnUh27pZ92GHs1dM9sVWlTD#DmJ8#LWKLRmO$HRoFZPdCUvk6y8sFELw1Tk43A#PwGI7aR9E1fBZQaObQBYbCJR#6NUoNE4Ia$BVSKlT8RMyjsqcfwWDRIHwj0LT2MjftLqELr6zQW#RQ2wr81#eXYEvWGId45dkJmdSJAdyXLybH3XqnK#JNoAJ#7vd0PzGLF3gFTgQFnMzsGZcXx6dkVmL$mMTF$4Rz2lORJN79#$#nEXF9e7OsRu8wGvAU1PGOddQu7gutmT62hFX2#NyKnUm#$oOVu429TmJOozWVmaP$CcVWBrR$BrM1ViJ1Umhu$0aZBS1AW#Jl9XHpqAr7Hk2bGVf$Tmel9485O7rKKCstsTsCE4MatlQxRI47GTg1LGVPpImuHQKwAs1zsepGeNOkJm58bwYz9JkPsRKSe5GNrSGrNku6vyE$UbLBuB7lRn5Y90L6t7zYV$hTHIwYlNA4qn7zxBz$ETsBEbyJ2A9sqyRzB6B51zl7a835Lfe$IWYbIUH$0eIkT1r8h7KGPFe2mWJURPs5$ivhtAdNm8g3xUDWGuDptF1$W8fGFn21z2UYzANk6tWVMrs2WsYFLYdLWhreZLGFNnXY4mLF6So1Ehn4gnGYmNoyHIiKI9LHnYjb92IL9AYKUKqcAiaYR6A9M1wkEjGe0UpXG3nMrYj1Wb7XOZnGZna1WkXecXua7nW7X1wII6YFl5KQKNJG6gZpS90QBs9b86aJ#NtTVRWm1ZsF$BxkkDmNb4zV6Mu3oY#dWpS1vHVRmDE8#eFju0d4TK7wV#yuUg50$f31FW7bUnynzAib9MASOPIenIwNoS6YnDbYPBawN9qcHfYhIcyArt5#FAUJ7spj9aQR8qMPgAq1JetrxUrF$s4cYhvY6qSbtNUZovRNQcNW8vZ2IVSfOs3HHNwNC1#$YwrehFKexIKRTsdj84rfyfyhpwS93svKVECpI1rb8BP#GObnOvhz1xUdg31zJJz7TadZtRl7oRwtktlxmKk3Ws9DoTe7qcRQvlCf7#RQvVU8ldXyFFEFysJhmqGXvxskkpzZ9BS2A$pcaHihPYeDOgvPJhEIj2rjOFsBV5qEhA25dRAs1howBLW0XPkoXWQvUZrUe8MRigO6ink$Bw25dxSS2Zh3nQVHWXQpyFsDhBqUgR25dxOy3MDYDIuY9ZhLBIimQbYw$rL4c9p7ggr7Ijfyfb4V9OjK2VhzwgIeIihHEKjLT7oDehWx8sEqBMvWJmlKvDGsczLSi8MNj3KBxjV86ilQI0jLq3rd1TKBXZWcerAwXMouDgjJMeLgy5qufR1zNgrg1QTG#cbJ8mg5Q3VPvvlSM$zpFo6sISaVCluuoyAPWHvkNQvh5qInWHtl1OUlAyz#7LC28GZGodDWuyHdnfMnXMRIl2gcrjMBMz7rPjduPJcr8XhDfgXrMRzpac66tNXbLRyx1gQnkssTUIj#GjUKl#VCi7TBRZhXUT$PQy9M$9M$AMl2KVxlMkJ23ItCz$QNv0$tMkmfVdKk8VF9usRlRUZdEybXfN3hVXjjoER#3st84xSYVkp3VoJLvASmheoYcWZGBHLgWZxxdhCbrBYqAWp#NtDuWM#chjvLf22jaeYffGDCLGBCLHF2LGBYLICIfE9IY9sb1RQaSt44l9ifH6vQWyLQ2AL8agKnLAfwgKGPjf2rN3Kwv1DV74S#6jEeYtJeYz#eZ01deqDaGSN4tNqBNKYBBfEcgCA36qTdJ3J$M0RyXbUiNlGFjC#AaIlxsV#1lSy0#Qy8rwuzwBxl2Aduknbe#VgaUBXh$JJ$nSD$nr7lgVpxtXbw9a9twU4p$NJ$nCD$pQ4hyWTacwn2l#3kZ8np#E9s3WR$SJVxCR$Zw9d##RezICccDkq$he3N#JoV#Pb1MW$pkvuM#I#3teTkefiOrqdbVyRPXp2#FlzXD$ayVuDyTUKV6leHN6xrWaVYxrfZxKb$fHVxUqjr$XCxmnYaRJ61ghp$3ZCEUFn#epaIRHP9f2KsaQJQV7QGRDf5bO4UPWHPghhmfFqpoQZvLg0KRhixI85cF#MUg6keoMOttGVi5nFJs7jMmDrZHN$KwJLQ5Qm5uik70#E1Xn7zX3y84n7aAre6QHFjZgz44DV6hfCykbr99QKMkimkr3jg3sVy076vm#C2BFc0loVR0kP0jsH7miR2$I1#pqWQTPCIja2x92y85XnVcomEM3JFZ0rUDygeTnOSUus1hHER46BAbrtcOabm#AiYLK2xQ6u0Dj3nnw9EOMuOEYBOba76Y$4ZmqP0kgHTo2j10iqCu97B85gJxZm1yx8Xq7eVl0$#Szp4rs5sR6J7Zm44fP$xo8t17CbVNqKqGcEVJFoP0jh0w4cg3gq5yJPm06rn1ItUnfgdyowG3coKpCazglwR5p1S$dzM1XwFkPlA2UrQwGaRMrA51ahKteo2nNm8rkc0vzf1HjnTwmzBnfKFr$07Q7ZX$8A1bE3z486aaFwwkLDbFjrLukoNs5tUqSwZ2zXoYfVtSlcKfJ2fL1T7ixXuPJL$WqvUAJlr#g5KQzetIDcYVhX5LlBkt1HzEzFynwNP5Ioy#uoGjhVFexAnmAA#f6VJNO24h5h92g8#o6F#lXFagVbxNrWa6Hw6jkH533iLFr7pL$zDal8Ahvb7JXKRLPuSAZZg9E5n0r5$kDJK3iY7iuKLdVHxa#kT3VKT#nTS0dq$G99seglKGRg3q#6sYTlcDRHplmsGwSxUZfHhsdUQWD9se7u6b$frk7kuRU4IMrgGcmgkCSPFw44xLQeG$hzpJTyqREe72YrlQ0c$#no$xQqIAyiyHM8QYsyECA9we$U1QgXMgXoZFSnNTgi3HPcYnDbYPBawN9qcHfiZHPcYnDbYPlRzJz$zlB1MnbEgCjz7XoE#nC7GFbodIkgzN5tqVQf$t5H5gx7$UZHPvNNmuIoKlaIArQv1ocF3rTsWFgjWlhJVEpzqT38Nk3j5QshWwgQTBc$1OFqlBRN5wUpiByluaZ$Np4F1RCB16vv$j$Rks5deaiQorhBMijQwtrD5BFDnIFMTPUrDO6gC7oxVdpRGHEQrQh$rQhGDTbhsTaoZJEoCverS$8L2#O4UPbfSlqM6eX5DIMPMcpj5dQ$l#qMVAMl2LloKTCFj0zviLcloLloLlobhmbRyc7VxqxVzAmoiFvmMEfyRS4NwM5sr4JRwKobKkTwKQwYRhGpTILRg5RgHjrfzkyb3PnrsLytyIb3Ua0j1NgHvwxBbFDjY8HNZ2#lu7w4xvQUxxGcfIxnkW$hXUdWAffQJFXcWwgPwIvhSRHy01HMWENJERV1a#RAjiqGFepo7r8L6uc#Az4bLv5UIdmhy4h4LNMz1m1BqCKCnIyhlv$7L3bLgJzVmnKkIVoAAiyp8LJUOQq8wgWdKKHCEwHEbOHHMsGwVrINptKtulyE#0jN6rAFudyVKYeWU9Th4HKuItPvsRI1p$B$4AN37$dIcFs86K4w2yZ7zTEyk5ITgF1gyIwsjXA5CQjKWcouxGqdhigTGl9iqrjEqEseIot1z2l9CcRk9V7ZF3TZjiLo3SnfQyeB1$JKk8CaNoPPxqq2d66laGj19tsKByFtRC3umJgLQIR6ENsiVxssLrVt7B9NpFP$uh1e#FWqmx87oOgtXJvTF3#HbtnQSWZzgDNGwO$RBaMwIsohuaeGp9gA#GsoRBQH2beK#OQzFqSoj#M$UaawxlB$4oPbtD2cLaoVvFaAw7xAUZU3XtdPDbkeXALPNeFwZUWVYTHxEs8Yvf6kQsMmQDsIFwtgxzLNiGDSqw95g21o7yCFNBEY8LkHZ$Y7Z3oySDTxU8VGzthuAU84kgxohFiKk$PelplYU37raJf9Q0JyqXwO$3VmBkwwcDx6Jpz7jZvX97cR8CdO0vCdmWEknmvI2#2VJT8cL4k7HMgexwDA##8WkmEy5YPnxDFXox7rI0yitHj$aL$QH9HLR0Kn63PjKXZ7kOtCSwx88rvDwOFQ2xIc8yLnAeDzbVjwTw$giFSymx4JuaP8FWvPhhiurK6Zn4eVq#cPnDLH0oMaEC$DfKegQfy5jqHAz#W7drEQYthHo8jrwdu7gX3l2RDbdMZaPQnK7M6ovQiciYlaZ8OWrNtmxxcu9ZZ7It1VmQ7denOy27WbI1u2BmX#efrAWFZnGOxRH#0u0TjhNGC1pq46ePwzDK1lHbZPDynHzgWEnwn6dMpB9kC#gUCT2hyLn7ndlIXaOzhJrHIaNtgXRhdaS#ITHsHRYjrB8SEZ8Cuu9QyroZBV0DbYFKuh6KbvnPu1XXN3csDknNySb2UBCUQx7WEX77kM0F2CtVWUJlU0Y7k7M#3DD#y2teFz3u8VKz4F6Ly31iHB2KnXXodmP5tV8Ib0R7Z#04oy676MSZSXFmleCzGbW0x4Vlnyo1N0sLVe0ppIShdy0N6GyKlKGuVEBv2ETRzp6gGXIsNt8yysYN68$qqU1B6G36a4OE99I5$1ROFq7E9Xe6rAG6ofO2VY6Vck1AwVqGz#bqAyrHYCkeHlwKw8LqQzNYsbReXZ$r6OWhg46Ebda4QiH#r2FLNOImWHYezWdBiSH8HbmbjaOQjYMLHFnXrUKJ9w5jY6keUHHfZ9R4Sg3pwW6USWB6L33yaLaGUlihiYZBOdepdbrZ9U1PHjo6joI8c4viXVyhr$19Rc9#dKSRxv7F7F968sCsSwAgBteZnb5Eu3KtDJsEzNUagZnrjAfVnLAwFgpxj7Oabvw7exmrktoppsz4EyHUR0tu6#U6Q0jG$23u8VVa37ECZ$fnBPyALqYRd#FINSCbr9zaqRvORRwf7p2OFAU0ln00ZRkZwGF4kLa8Vrxldoots9OzdW$c1$y7SFT#GZv5pJSo40dhs585xt9NEFEXUb$b90LroBs2h4a2$6icslxgNqpRVxMpr2#HpJEcftjibVs7myecUw#b7LpggRk7wqYpbUagPD$pjgsUycCC6ZvlZAhFtDU6LDJWla79oJnSVRvBfui5EERRZcvlAPe4mxvV#2ULZ97wYUxkORFTyIhmvByjQIDsxNMNnPqprlLpfk8C6ZpvZSFfTucmroSk#nKPXhi1PB6M7gNrbjCLw5JT9ujZSROc$tU090rnbKRyPl7oXywo$X3tVKQcZgUGzN7K9TqkxVtULnJHsfJFb7ZS1PySonKrzwUzAAvZB4vQuOsOESi$RpVgnvqx0N9U0TJbklXOFq84r9huDoh3E97m2$oLA6QpXyGSCsOGFDJlSzIQiBTpVs6Oen$mTTqJAV66IDwqVPJIyJrrvHtbJNL$G4fIPvch7R5FzNkHFklA9SGRdfIOxi2Oh6QvyL6t9rqkVo7SHqGsaNux3dczXjxQFmHuWVZoujjQdv9DxFvML1hTLTvN5bP0yoLLcMorj$WjxYbBQEcsoUxGhdOfzOk8kKzqVfhg11YzML$ODuovLuXSRQBRBrIPvkQVoO0XOSkpnQTdtYX9xXKccqBiDx85IfNnFKndE3sMnhocBlPkos5GkrsV551EsT5EwjqaMwx9jkQdkIrSw3UUKDEozeh9SPL6cyPBM4$ayKzst1a#M#ziqxEFIS9QqrtJ9s0UPskFiPLzhgZFDy#MA6JowZi7Z$qPPZYoxnoMNuBPMQdjNKtglkKxAotShvUMxal9p3AxSfJCI$uf$n06nNqzZ$oyM2EnunLFgJf4ciDzKTwWeLO#0NWAz1i8kNSM8Lh4ZLT4Z5POAhNMCm5vNb4Ax555Q98aIehWe9XA5GoI8U14dAeeAeeQEW$EYkb8zBEhekIlK5RWZBHg8C#8FyRluJVmgVX4$Yv$4Z#87yRtuJdmhlX5VYw$4b#8ByRduJ7mgFX4VYu$4QV6X#42yBzuJxuftnDlYb7XBl2dU4A#BryIhuXLnKhmiJeYNn77nbpWh$XJObGkS#aGLK6Nrk6WehbHV5Ls4$3z6XDONdC34GH1spEfoyQ9wIjmeEejEegCkWR4cC4#9fg0ceh5UTftwWVg9#h7waNfQNQmkKfzL5weBL4I3mEb2t21QYnRgL#etwjVgZ#eFwlVgT#gtwk$gd#ePzG$r7$LVzPnW4ILiGX4uHOXs8EpuHHlHKhGIpONpVpeHsU9QSOsucfoNQ0IwNkmLUyHkiKli53l4Th5DR1LRn6Qn2NMBGOl4i#Z9CZ9TuWctt2ndQgQf5ATeWTL3u8Ggi5A8kq686Z7OAJ58TCQzXwdD0D2T8Cp2ee$ehPVT8NhflBj#xoPkmVrcSQkpJLTrkqWLEF#eszJDwYPrexf1NQ#kKzUgQzJLwdDgdhfAnQoj7ZBarJsYl2WdClMs6Q2gAfwMUapKraik0zKJMLf4YRgYbeezgFgAgA#U17zBnMbJVL$5sLBzNCLfKFr5$HNtiofcM5LL4SR2Bg85pdIYf5WeSi5x2foc1KxQef#k$t5fzNJzFitPYwdwVOhCJTRlaw1rgRfLu9ocRb5nSbMn8geunQilWt22KR5Agf#2Vb9$LZzJtr5VLq#eHsK$TwdxfRRv0ZEUc2jp4$Nx19aRhzyV4$Da$b4DJK#DKvU8EQwnBPunOXftFLRqb2bMl5skwF0gqRaeYU2k$3uXbUPCdJFL7n67SJycAebBHKsagXdbAdh9lUaaCOZe22aWrdz1k3T5wRzmd4zv$q4QH3OGqq7qwo3IB#d4j1NvhKYFHjeWBQsOylxHiqwoWHHJtZyQXJQZq7Ol#5xaZo9z57m$#7xmVJhPQ0$u7l3f50EoqoBmntMoWw9bMgDO4zSepiGrYdVMBmPVZFQBqTv8QnHhuXh5cRX6ySxw6R1v1coQ2JuJV1RuBF3PqBa4z0JqFW5PWs8bnT5koEr6VpP2TYDYx03o1v2U0reAcWjwqabHz29q7OBCGBJHg4yXib4$rFVJkKPH83iTGzqnb1z3sJ6K7KRwCCe6W0z0sG2KdK3#1D8lw6G7HTCsbENJST2TJee2sNIQWFm4v2VeQHiDHdumz3uD$ZJuFKwA0jbe8j86HO5ij0dfJU0lwyHqbwJnakxLIQ5vuFF0DuDhTBTE2iq7dm#k$PfbKNIVJZPiSXXae#tW#JH49nkD1HyBlWDSe$jrij4Zu8#0hmFFfmTqij6Zu8#2BmDV1huUl23jbFIWJZOQ1puEV3duSl0Du6OQYhAXu9F09u6l05y1FWny6FXayCdWAy5NWWy77mu#1NmA#2fmxV$pU0XS#$RNLF2ffFt$7ZOGqqZmaU2FWJy6lXfyDVZ3Ejdf6V1dmDU2hmKV0Ju2Cjflo2q0NmE#1dmBU22q46sqV#ip3NmQ#FFWpuFtzK9F$Gy8hitq");
    private WorkingParseResult fWorking;
    private final List<IRecoveryStrategy> recoveryStrategies;
    private JSFlexScanner fScanner;
    private IProblem.Severity fSemicolonSeverity = IProblem.Severity.WARNING;

    private void attachPostDocumentationBlocks(JSParseRootNode root, String source) {
        block3: for (Symbol block : this.fScanner.getVSDocComments()) {
            int index = block.getStart() - 1;
            while (index >= 0 && Character.isWhitespace(source.charAt(index))) {
                --index;
            }
            IParseNode node = root.getNodeAtOffset(index);
            if (!(node instanceof JSNode)) continue;
            switch (node.getNodeType()) {
                case 21: {
                    IParseNode parent = node.getParent();
                    if (parent.getNodeType() != 70) continue block3;
                    ((JSNode)parent).setPostDocumentation(block);
                    break;
                }
                default: {
                    ((JSNode)node).setPostDocumentation(block);
                }
            }
        }
    }

    private void attachPreDocumentationBlocks(JSParseRootNode root, String source) {
        List<Symbol> sDocComments = this.fScanner.getSDocComments();
        for (Symbol comment : sDocComments) {
            int index = comment.getEnd() + 1;
            while (index < source.length() && Character.isWhitespace(source.charAt(index))) {
                ++index;
            }
            IParseNode node = root.getNodeAtOffset(index);
            if (!(node instanceof JSNode)) continue;
            if (node instanceof JSGroupNode && node.getFirstChild() instanceof JSFunctionNode) {
                ((JSNode)node.getFirstChild()).setPreDocumentation(comment);
                continue;
            }
            if (node instanceof JSIdentifierNode && node.getParent() instanceof JSNameValuePairNode) {
                JSNameValuePairNode entry = (JSNameValuePairNode)node.getParent();
                ((JSNode)entry.getValue()).setPreDocumentation(comment);
                continue;
            }
            IParseNode statement = ((JSNode)node).getContainingStatementNode();
            if (statement instanceof JSAssignmentNode) {
                ((JSNode)statement.getLastChild()).setPreDocumentation(comment);
                continue;
            }
            switch (node.getNodeType()) {
                case 64: {
                    JSVarNode varNode = (JSVarNode)node;
                    ((JSNode)varNode.getFirstChild().getLastChild()).setPreDocumentation(comment);
                    break;
                }
                default: {
                    ((JSNode)node).setPreDocumentation(comment);
                }
            }
        }
    }

    protected Symbol getLastSymbol() {
        Symbol result = null;
        if (this.top >= 0 && this.top < this._symbols.length) {
            result = this._symbols[this.top];
        }
        return result;
    }

    public synchronized ParseResult parse(IParseState parseState) throws Exception {
        WorkingParseResult working = new WorkingParseResult();
        this.parse(parseState, working);
        return working.getImmutableResult();
    }

    protected synchronized void parse(IParseState parseState, WorkingParseResult working) throws Exception {
        this.fWorking = working;
        String severity = Platform.getPreferencesService().getString("com.aptana.js.core", "missing_semicolon_severity", null, null);
        this.fSemicolonSeverity = IProblem.Severity.create((String)severity);
        String source = parseState.getSource();
        this.fScanner = new JSFlexScanner();
        this.fScanner.setSource(source);
        boolean attachComments = true;
        boolean collectComments = true;
        if (parseState instanceof JSParseState) {
            JSParseState jsParseState = (JSParseState)parseState;
            attachComments = jsParseState.attachComments();
            collectComments = jsParseState.attachComments() || jsParseState.collectComments();
        }
        this.fScanner.setCollectComments(collectComments);
        try {
            JSParseRootNode result;
            try {
                result = (JSParseRootNode)((Object)this.parse(this.fScanner));
                if (attachComments) {
                    this.attachComments(source, result);
                }
                if (collectComments) {
                    this.collectComments(result);
                }
            }
            finally {
                if (this.fScanner != null) {
                    this.fScanner.yyclose();
                    this.fScanner = null;
                }
            }
            int start = parseState.getStartingOffset();
            int length = source.length();
            result.setLocation(0, length - 1);
            if (start != 0) {
                ParseUtil.addOffset((IParseNode)result, (int)start);
            }
            this.fWorking.setParseResult((IParseRootNode)result);
        }
        finally {
            this.fWorking = null;
        }
    }

    private void attachComments(String source, JSParseRootNode result) {
        this.attachPreDocumentationBlocks(result, source);
        this.attachPostDocumentationBlocks(result, source);
    }

    private void collectComments(JSParseRootNode result) {
        List<Symbol> sDocComments = this.fScanner.getSDocComments();
        List<Symbol> vsDocComments = this.fScanner.getVSDocComments();
        List<Symbol> singleLineComments = this.fScanner.getSingleLineComments();
        List<Symbol> multiLineComments = this.fScanner.getMultiLineComments();
        ArrayList<JSCommentNode> comments = new ArrayList<JSCommentNode>(sDocComments.size() + vsDocComments.size() + singleLineComments.size() + multiLineComments.size());
        for (Symbol symbol : sDocComments) {
            comments.add(new JSCommentNode(90, symbol.getStart(), symbol.getEnd()));
        }
        for (Symbol symbol : vsDocComments) {
            comments.add(new JSCommentNode(91, symbol.getStart(), symbol.getEnd()));
        }
        for (Symbol symbol : singleLineComments) {
            comments.add(new JSCommentNode(92, symbol.getStart(), symbol.getEnd()));
        }
        for (Symbol symbol : multiLineComments) {
            comments.add(new JSCommentNode(93, symbol.getStart(), symbol.getEnd()));
        }
        result.setCommentNodes(comments.toArray(new IParseNode[comments.size()]));
    }

    protected void recoverFromError(Symbol token, Parser.TokenStream in) throws IOException, Parser.Exception {
        boolean success = false;
        if (this.recoveryStrategies != null) {
            for (IRecoveryStrategy strategy : this.recoveryStrategies) {
                if (!strategy.recover((IParser)this, this.getLastSymbol(), token, in, this.report)) continue;
                success = true;
                break;
            }
        }
        if (!success) {
            super.recoverFromError(token, in);
        }
    }

    public JSParser() {
        super(PARSING_TABLES);
        this.report = new JSEvents();
        this.recoveryStrategies = new ArrayList<IRecoveryStrategy>(10);
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.SEMICOLON, ";", new JSTokenType[0]){

            public boolean recover(IParser parser, Symbol lastToken, Symbol currentToken, Parser.TokenStream in, Parser.Events report) throws IOException {
                boolean recovered = super.recover(parser, lastToken, currentToken, in, report);
                if (recovered && JSParser.this.fSemicolonSeverity != IProblem.Severity.IGNORE) {
                    JSParser.this.fWorking.addError((IParseError)new ParseError("com.aptana.contenttype.js", lastToken, Messages.JSParser_MissingSemicolonMsg, JSParser.this.fSemicolonSeverity));
                }
                return recovered;
            }
        });
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.RPAREN, ")", JSTokenType.SEMICOLON, ";", new JSTokenType[0]));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", JSTokenType.SEMICOLON, ";", JSTokenType.DOT, JSTokenType.NEW, JSTokenType.EQUAL));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", JSTokenType.DOT, JSTokenType.NEW, JSTokenType.EQUAL));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", JSTokenType.LPAREN));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", JSTokenType.COLON, ":", JSTokenType.DOT));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.LCURLY, "{", JSTokenType.RCURLY, "}", JSTokenType.RPAREN));
        this.recoveryStrategies.add(new IRecoveryStrategy(){

            public boolean recover(IParser parser, Symbol lastToken, Symbol currentToken, Parser.TokenStream in, Parser.Events report) throws IOException {
                boolean result = false;
                if (JSParser.this.top >= 2) {
                    Symbol symbol1 = JSParser.this._symbols[JSParser.this.top - 2];
                    Symbol symbol2 = JSParser.this._symbols[JSParser.this.top - 1];
                    if (lastToken.getId() == JSTokenType.COMMA.getIndex() && symbol2.value instanceof List && symbol1.getId() == JSTokenType.LPAREN.getIndex()) {
                        Symbol term = new Symbol(JSTokenType.IDENTIFIER.getIndex(), currentToken.getStart(), currentToken.getStart() - 1, (Object)"");
                        Parser.Simulator sim = new Parser.Simulator((Parser)JSParser.this);
                        in.alloc(2);
                        in.insert(term, currentToken);
                        in.rewind();
                        if (sim.parse(in)) {
                            result = true;
                            in.rewind();
                            report.missingTokenInserted(term);
                        }
                    }
                }
                return result;
            }
        });
        JSInsertionRecoveryStrategy completeProperty = new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", new JSTokenType[0]);
        completeProperty.addCurrentTokenTypes(new JSTokenType[]{JSTokenType.RCURLY});
        this.recoveryStrategies.add((IRecoveryStrategy)completeProperty);
        JSInsertionRecoveryStrategy completeProperty2 = new JSInsertionRecoveryStrategy(JSTokenType.COLON, ":", JSTokenType.IDENTIFIER, "", new JSTokenType[0]);
        completeProperty2.addCurrentTokenTypes(new JSTokenType[]{JSTokenType.RCURLY});
        this.recoveryStrategies.add((IRecoveryStrategy)completeProperty2);
    }

    protected Symbol invokeReduceAction(int rule_num, int offset) {
        switch (rule_num) {
            case 0: {
                Symbol _symbol_p = this._symbols[offset + 1];
                ArrayList _list_p = (ArrayList)_symbol_p.value;
                JSNode[] p = _list_p == null ? new JSNode[]{} : _list_p.toArray(new JSNode[_list_p.size()]);
                return new JSParseRootNode((Symbol[])p);
            }
            case 1: {
                return new JSParseRootNode();
            }
            case 2: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 3: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 5: {
                Symbol ident = this._symbols[offset + 2];
                Symbol _symbol_params = this._symbols[offset + 3];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 4];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSFunctionNode(new JSIdentifierNode(ident), params, body);
            }
            case 54: {
                Symbol f = this._symbols[offset + 1];
                Symbol _symbol_params = this._symbols[offset + 2];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 3];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSFunctionNode(new JSEmptyNode(f), params, body);
            }
            case 56: {
                return new JSParametersNode(new JSNode[0]);
            }
            case 57: {
                Symbol _symbol_params = this._symbols[offset + 2];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                return params;
            }
            case 58: {
                Symbol _symbol_list = this._symbols[offset + 1];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                Symbol ident = this._symbols[offset + 3];
                JSIdentifierNode identifier = new JSIdentifierNode(ident);
                list.addChild((IParseNode)identifier);
                return list;
            }
            case 59: {
                Symbol ident = this._symbols[offset + 1];
                JSIdentifierNode identifier = new JSIdentifierNode(ident);
                return new JSParametersNode(identifier);
            }
            case 60: {
                return new JSStatementsNode(new JSNode[0]);
            }
            case 61: {
                Symbol _symbol_s = this._symbols[offset + 2];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                JSNode[] s = _list_s == null ? new JSNode[]{} : _list_s.toArray(new JSNode[_list_s.size()]);
                return new JSStatementsNode(s);
            }
            case 64: {
                Symbol v = this._symbols[offset + 1];
                Symbol _symbol_l = this._symbols[offset + 2];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                JSNode[] l = _list_l == null ? new JSNode[]{} : _list_l.toArray(new JSNode[_list_l.size()]);
                Symbol s = this._symbols[offset + 3];
                JSVarNode node = new JSVarNode(v, l);
                node.setSemicolonIncluded(s.getEnd() >= s.getStart());
                return node;
            }
            case 65: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                e.setSemicolonIncluded(true);
                return e;
            }
            case 76: {
                Symbol s = this._symbols[offset + 1];
                JSEmptyNode node = new JSEmptyNode(s);
                ((JSNode)node).setSemicolonIncluded(true);
                return node;
            }
            case 77: {
                return new JSErrorNode();
            }
            case 80: {
                Symbol v = this._symbols[offset + 1];
                Symbol _symbol_l = this._symbols[offset + 2];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                JSNode[] l = _list_l == null ? new JSNode[]{} : _list_l.toArray(new JSNode[_list_l.size()]);
                JSVarNode node = new JSVarNode(v, l);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 81: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                e.setSemicolonIncluded(true);
                return e;
            }
            case 92: {
                Symbol s = this._symbols[offset + 1];
                return new JSEmptyNode(s);
            }
            case 93: {
                return new JSErrorNode();
            }
            case 94: {
                return new JSStatementsNode(new JSNode[0]);
            }
            case 95: {
                Symbol _symbol_a = this._symbols[offset + 2];
                ArrayList _list_a = (ArrayList)_symbol_a.value;
                JSNode[] a = _list_a == null ? new JSNode[]{} : _list_a.toArray(new JSNode[_list_a.size()]);
                return new JSStatementsNode(a);
            }
            case 96: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 97: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 98: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 99: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 100: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 101: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 102: {
                Symbol i = this._symbols[offset + 1];
                return new JSDeclarationNode(new JSIdentifierNode(i), null, (JSNode)new JSEmptyNode(i));
            }
            case 103: {
                Symbol i = this._symbols[offset + 1];
                Symbol e = this._symbols[offset + 2];
                Symbol _symbol_expression = this._symbols[offset + 3];
                JSNode expression = (JSNode)((Object)_symbol_expression.value);
                return new JSDeclarationNode(new JSIdentifierNode(i), e, expression);
            }
            case 104: {
                Symbol i = this._symbols[offset + 1];
                return new JSDeclarationNode(new JSIdentifierNode(i), null, (JSNode)new JSEmptyNode(i));
            }
            case 105: {
                Symbol i = this._symbols[offset + 1];
                Symbol e = this._symbols[offset + 2];
                Symbol _symbol_expression = this._symbols[offset + 3];
                JSNode expression = (JSNode)((Object)_symbol_expression.value);
                return new JSDeclarationNode(new JSIdentifierNode(i), e, expression);
            }
            case 106: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_sn = this._symbols[offset + 5];
                JSNode sn = (JSNode)((Object)_symbol_sn.value);
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSIfNode(l, e, r, sn, s);
            }
            case 107: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSIfNode(l, e, r, s, (JSNode)new JSEmptyNode((Symbol)s));
            }
            case 108: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_sn = this._symbols[offset + 5];
                JSNode sn = (JSNode)((Object)_symbol_sn.value);
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSIfNode(l, e, r, sn, s);
            }
            case 109: {
                Symbol _symbol_s = this._symbols[offset + 2];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                Symbol l = this._symbols[offset + 4];
                Symbol _symbol_e = this._symbols[offset + 5];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 6];
                JSDoNode node = new JSDoNode(s, l, e, r);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 110: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSWhileNode(l, e, r, s);
            }
            case 111: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol s2 = this._symbols[offset + 4];
                Symbol r = this._symbols[offset + 5];
                Symbol _symbol_s = this._symbols[offset + 6];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 112: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol s2 = this._symbols[offset + 4];
                Symbol _symbol_a = this._symbols[offset + 5];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 113: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol _symbol_c = this._symbols[offset + 4];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 5];
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 114: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol _symbol_c = this._symbols[offset + 4];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 5];
                Symbol _symbol_a = this._symbols[offset + 6];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, c, s2, a, r, s);
            }
            case 115: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol s2 = this._symbols[offset + 5];
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 116: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol s2 = this._symbols[offset + 5];
                Symbol _symbol_a = this._symbols[offset + 6];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 117: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol _symbol_c = this._symbols[offset + 5];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 6];
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 118: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol _symbol_c = this._symbols[offset + 5];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 6];
                Symbol _symbol_a = this._symbols[offset + 7];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, c, s2, a, r, s);
            }
            case 119: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol s2 = this._symbols[offset + 6];
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 120: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol s2 = this._symbols[offset + 6];
                Symbol _symbol_a = this._symbols[offset + 7];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 121: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 7];
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 122: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 7];
                Symbol _symbol_a = this._symbols[offset + 8];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 9];
                Symbol _symbol_s = this._symbols[offset + 10];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, c, s2, a, r, s);
            }
            case 123: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 4];
                Symbol _symbol_o = this._symbols[offset + 5];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForInNode(l, i, in, o, r, s);
            }
            case 124: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 5];
                Symbol _symbol_o = this._symbols[offset + 6];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForInNode(l, (JSNode)new JSVarNode(v, i), in, o, r, s);
            }
            case 125: {
                Symbol _symbol_s = this._symbols[offset + 2];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                Symbol l = this._symbols[offset + 4];
                Symbol _symbol_e = this._symbols[offset + 5];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 6];
                JSDoNode node = new JSDoNode(s, l, e, r);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 126: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSWhileNode(l, e, r, s);
            }
            case 127: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol s2 = this._symbols[offset + 4];
                Symbol r = this._symbols[offset + 5];
                Symbol _symbol_s = this._symbols[offset + 6];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 128: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol s2 = this._symbols[offset + 4];
                Symbol _symbol_a = this._symbols[offset + 5];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 129: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol _symbol_c = this._symbols[offset + 4];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 5];
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 130: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol _symbol_c = this._symbols[offset + 4];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 5];
                Symbol _symbol_a = this._symbols[offset + 6];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, c, s2, a, r, s);
            }
            case 131: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol s2 = this._symbols[offset + 5];
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 132: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol s2 = this._symbols[offset + 5];
                Symbol _symbol_a = this._symbols[offset + 6];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 133: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol _symbol_c = this._symbols[offset + 5];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 6];
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 134: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol _symbol_c = this._symbols[offset + 5];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 6];
                Symbol _symbol_a = this._symbols[offset + 7];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, c, s2, a, r, s);
            }
            case 135: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol s2 = this._symbols[offset + 6];
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 136: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol s2 = this._symbols[offset + 6];
                Symbol _symbol_a = this._symbols[offset + 7];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 137: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 7];
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 138: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 7];
                Symbol _symbol_a = this._symbols[offset + 8];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 9];
                Symbol _symbol_s = this._symbols[offset + 10];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, c, s2, a, r, s);
            }
            case 139: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 4];
                Symbol _symbol_o = this._symbols[offset + 5];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForInNode(l, i, in, o, r, s);
            }
            case 140: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 5];
                Symbol _symbol_o = this._symbols[offset + 6];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForInNode(l, (JSNode)new JSVarNode(v, i), in, o, r, s);
            }
            case 141: {
                JSContinueNode node = new JSContinueNode();
                node.setSemicolonIncluded(true);
                return node;
            }
            case 142: {
                Symbol i = this._symbols[offset + 2];
                JSContinueNode node = new JSContinueNode(i);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 143: {
                JSBreakNode node = new JSBreakNode();
                node.setSemicolonIncluded(true);
                return node;
            }
            case 144: {
                Symbol i = this._symbols[offset + 2];
                JSBreakNode node = new JSBreakNode(i);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 145: {
                Symbol r = this._symbols[offset + 1];
                JSReturnNode node = new JSReturnNode(new JSEmptyNode(r));
                node.setSemicolonIncluded(true);
                return node;
            }
            case 146: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                JSReturnNode node = new JSReturnNode(e);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 147: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSWithNode(l, e, r, s);
            }
            case 148: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSWithNode(l, e, r, s);
            }
            case 149: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol rc = this._symbols[offset + 6];
                return new JSSwitchNode(lp, e, rp, lc, rc, new JSNode[0]);
            }
            case 150: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                ArrayList _list_c = (ArrayList)_symbol_c.value;
                JSNode[] c = _list_c == null ? new JSNode[]{} : _list_c.toArray(new JSNode[_list_c.size()]);
                Symbol rc = this._symbols[offset + 7];
                ArrayList<JSNode> nodes = new ArrayList<JSNode>();
                JSNode[] s = c;
                int _symbol_s = c.length;
                int r = 0;
                while (r < _symbol_s) {
                    JSNode statement = s[r];
                    nodes.add(statement);
                    ++r;
                }
                JSNode[] children = nodes.toArray(new JSNode[nodes.size()]);
                return new JSSwitchNode(lp, e, rp, lc, rc, children);
            }
            case 151: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_d = this._symbols[offset + 6];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                Symbol rc = this._symbols[offset + 7];
                return new JSSwitchNode(lp, e, rp, lc, rc, d);
            }
            case 152: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_d = this._symbols[offset + 6];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                Symbol _symbol_c = this._symbols[offset + 7];
                ArrayList _list_c = (ArrayList)_symbol_c.value;
                JSNode[] c = _list_c == null ? new JSNode[]{} : _list_c.toArray(new JSNode[_list_c.size()]);
                Symbol rc = this._symbols[offset + 8];
                ArrayList<JSNode> nodes = new ArrayList<JSNode>();
                nodes.add(d);
                JSNode[] jSNodeArray = c;
                int n = c.length;
                int s = 0;
                while (s < n) {
                    JSNode statement = jSNodeArray[s];
                    nodes.add(statement);
                    ++s;
                }
                JSNode[] children = nodes.toArray(new JSNode[nodes.size()]);
                return new JSSwitchNode(lp, e, rp, lc, rc, children);
            }
            case 153: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                ArrayList _list_c = (ArrayList)_symbol_c.value;
                JSNode[] c = _list_c == null ? new JSNode[]{} : _list_c.toArray(new JSNode[_list_c.size()]);
                Symbol _symbol_d = this._symbols[offset + 7];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                Symbol rc = this._symbols[offset + 8];
                ArrayList<JSNode> nodes = new ArrayList<JSNode>();
                JSNode[] jSNodeArray = c;
                int n = c.length;
                int s = 0;
                while (s < n) {
                    JSNode statement = jSNodeArray[s];
                    nodes.add(statement);
                    ++s;
                }
                nodes.add(d);
                JSNode[] children = nodes.toArray(new JSNode[nodes.size()]);
                return new JSSwitchNode(lp, e, rp, lc, rc, children);
            }
            case 154: {
                JSNode statement;
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_c1 = this._symbols[offset + 6];
                ArrayList _list_c1 = (ArrayList)_symbol_c1.value;
                JSNode[] c1 = _list_c1 == null ? new JSNode[]{} : _list_c1.toArray(new JSNode[_list_c1.size()]);
                Symbol _symbol_d = this._symbols[offset + 7];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                Symbol _symbol_c2 = this._symbols[offset + 8];
                ArrayList _list_c2 = (ArrayList)_symbol_c2.value;
                JSNode[] c2 = _list_c2 == null ? new JSNode[]{} : _list_c2.toArray(new JSNode[_list_c2.size()]);
                Symbol rc = this._symbols[offset + 9];
                ArrayList<JSNode> nodes = new ArrayList<JSNode>();
                JSNode[] jSNodeArray = c1;
                int n = c1.length;
                int n2 = 0;
                while (n2 < n) {
                    statement = jSNodeArray[n2];
                    nodes.add(statement);
                    ++n2;
                }
                nodes.add(d);
                jSNodeArray = c2;
                n = c2.length;
                n2 = 0;
                while (n2 < n) {
                    statement = jSNodeArray[n2];
                    nodes.add(statement);
                    ++n2;
                }
                JSNode[] children = nodes.toArray(new JSNode[nodes.size()]);
                return new JSSwitchNode(lp, e, rp, lc, rc, children);
            }
            case 155: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 156: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 157: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol c = this._symbols[offset + 3];
                return new JSCaseNode(e, c, new JSNode[0]);
            }
            case 158: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol c = this._symbols[offset + 3];
                Symbol _symbol_s = this._symbols[offset + 4];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                JSNode[] s = _list_s == null ? new JSNode[]{} : _list_s.toArray(new JSNode[_list_s.size()]);
                return new JSCaseNode(e, c, s);
            }
            case 159: {
                Symbol c = this._symbols[offset + 2];
                return new JSDefaultNode(c, new JSNode[0]);
            }
            case 160: {
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_s = this._symbols[offset + 3];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                JSNode[] s = _list_s == null ? new JSNode[]{} : _list_s.toArray(new JSNode[_list_s.size()]);
                return new JSDefaultNode(c, s);
            }
            case 161: {
                Symbol i = this._symbols[offset + 1];
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_s = this._symbols[offset + 3];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                JSIdentifierNode id = new JSIdentifierNode(i);
                id.setLocation(i.getStart(), i.getEnd());
                return new JSLabelledNode(id, c, s);
            }
            case 162: {
                Symbol i = this._symbols[offset + 1];
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_s = this._symbols[offset + 3];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                JSIdentifierNode id = new JSIdentifierNode(i);
                id.setLocation(i.getStart(), i.getEnd());
                return new JSLabelledNode(id, c, s);
            }
            case 163: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                JSThrowNode node = new JSThrowNode(e);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 164: {
                Symbol _symbol_b = this._symbols[offset + 2];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                Symbol _symbol_c = this._symbols[offset + 3];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                return new JSTryNode(b, c, new JSEmptyNode((Symbol)c));
            }
            case 165: {
                Symbol _symbol_b = this._symbols[offset + 2];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                Symbol _symbol_f = this._symbols[offset + 3];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSTryNode(b, new JSEmptyNode((Symbol)b), f);
            }
            case 166: {
                Symbol _symbol_b = this._symbols[offset + 2];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                Symbol _symbol_c = this._symbols[offset + 3];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol _symbol_f = this._symbols[offset + 4];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSTryNode(b, c, f);
            }
            case 167: {
                Symbol i = this._symbols[offset + 3];
                Symbol _symbol_b = this._symbols[offset + 5];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                JSIdentifierNode id = new JSIdentifierNode(i);
                return new JSCatchNode(id, b);
            }
            case 168: {
                Symbol _symbol_b = this._symbols[offset + 2];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                return new JSFinallyNode(b);
            }
            case 171: {
                Symbol t = this._symbols[offset + 1];
                return new JSThisNode(t);
            }
            case 172: {
                Symbol i = this._symbols[offset + 1];
                return new JSIdentifierNode(i);
            }
            case 175: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 3];
                return new JSGroupNode(l, e, r);
            }
            case 176: {
                Symbol l = this._symbols[offset + 1];
                Symbol r = this._symbols[offset + 2];
                return new JSArrayNode(l, r, new JSNode[0]);
            }
            case 177: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 3];
                e.addChild((IParseNode)new JSNullNode());
                return new JSArrayNode(l, r, e);
            }
            case 178: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 3];
                return new JSArrayNode(l, r, e);
            }
            case 179: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                return new JSArrayNode(l, r, e, new JSNullNode());
            }
            case 180: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol _symbol_n = this._symbols[offset + 4];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol r = this._symbols[offset + 5];
                n.addChild((IParseNode)new JSNullNode());
                return new JSArrayNode(l, r, e, n);
            }
            case 181: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSElementsNode(e);
            }
            case 182: {
                Symbol _symbol_n = this._symbols[offset + 1];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSElementsNode(n, e);
            }
            case 183: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                l.addChild((IParseNode)e);
                return l;
            }
            case 184: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_n = this._symbols[offset + 3];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol _symbol_e = this._symbols[offset + 4];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                l.addChild((IParseNode)n);
                l.addChild((IParseNode)e);
                return l;
            }
            case 185: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                e.addChild((IParseNode)new JSNullNode());
                return e;
            }
            case 186: {
                return new JSElisionNode(new JSNullNode());
            }
            case 187: {
                Symbol l = this._symbols[offset + 1];
                Symbol r = this._symbols[offset + 2];
                return new JSObjectNode(l, r, new JSNode[0]);
            }
            case 188: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_p = this._symbols[offset + 2];
                ArrayList _list_p = (ArrayList)_symbol_p.value;
                JSNode[] p = _list_p == null ? new JSNode[]{} : _list_p.toArray(new JSNode[_list_p.size()]);
                Symbol r = this._symbols[offset + 3];
                return new JSObjectNode(l, r, p);
            }
            case 189: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_p = this._symbols[offset + 2];
                ArrayList _list_p = (ArrayList)_symbol_p.value;
                JSNode[] p = _list_p == null ? new JSNode[]{} : _list_p.toArray(new JSNode[_list_p.size()]);
                Symbol r = this._symbols[offset + 4];
                return new JSObjectNode(l, r, p);
            }
            case 190: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 191: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 192: {
                Symbol _symbol_n = this._symbols[offset + 1];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_v = this._symbols[offset + 3];
                JSNode v = (JSNode)((Object)_symbol_v.value);
                return new JSNameValuePairNode(n, c, v);
            }
            case 193: {
                Symbol _symbol_n = this._symbols[offset + 2];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol _symbol_body = this._symbols[offset + 5];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSNameValuePairNode(n, body);
            }
            case 194: {
                Symbol _symbol_n = this._symbols[offset + 2];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol p = this._symbols[offset + 4];
                Symbol _symbol_body = this._symbols[offset + 6];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                JSIdentifierNode ident = new JSIdentifierNode(p);
                JSParametersNode params = new JSParametersNode(ident);
                params.setLocation(ident.getStartingOffset(), ident.getEndingOffset());
                return new JSNameValuePairNode(n, params, body);
            }
            case 195: {
                Symbol i = this._symbols[offset + 1];
                return new JSIdentifierNode(i);
            }
            case 196: {
                Symbol s = this._symbols[offset + 1];
                return new JSStringNode(s);
            }
            case 197: {
                Symbol n = this._symbols[offset + 1];
                return new JSNumberNode(n);
            }
            case 201: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                return new JSGetElementNode(l, lb, r, rb);
            }
            case 202: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSGetPropertyNode(l, o, new JSIdentifierNode(r));
            }
            case 203: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol _symbol_a = this._symbols[offset + 3];
                JSArgumentsNode a = (JSArgumentsNode)((Object)_symbol_a.value);
                return new JSConstructNode(e, a);
            }
            case 205: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                return new JSGetElementNode(l, lb, r, rb);
            }
            case 206: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSGetPropertyNode(l, o, new JSIdentifierNode(r));
            }
            case 207: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol _symbol_a = this._symbols[offset + 3];
                JSArgumentsNode a = (JSArgumentsNode)((Object)_symbol_a.value);
                return new JSConstructNode(e, a);
            }
            case 209: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSConstructNode(e, new JSEmptyNode((Symbol)e));
            }
            case 211: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSConstructNode(e, new JSEmptyNode((Symbol)e));
            }
            case 212: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                JSArgumentsNode r = (JSArgumentsNode)((Object)_symbol_r.value);
                return new JSInvokeNode(l, r);
            }
            case 213: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                JSArgumentsNode r = (JSArgumentsNode)((Object)_symbol_r.value);
                return new JSInvokeNode(l, r);
            }
            case 214: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                return new JSGetElementNode(l, lb, r, rb);
            }
            case 215: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSGetPropertyNode(l, o, new JSIdentifierNode(r));
            }
            case 216: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                JSArgumentsNode r = (JSArgumentsNode)((Object)_symbol_r.value);
                return new JSInvokeNode(l, r);
            }
            case 217: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                JSArgumentsNode r = (JSArgumentsNode)((Object)_symbol_r.value);
                return new JSInvokeNode(l, r);
            }
            case 218: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                return new JSGetElementNode(l, lb, r, rb);
            }
            case 219: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSGetPropertyNode(l, o, new JSIdentifierNode(r));
            }
            case 220: {
                return new JSArgumentsNode(new JSNode[0]);
            }
            case 221: {
                Symbol _symbol_a = this._symbols[offset + 2];
                ArrayList _list_a = (ArrayList)_symbol_a.value;
                JSNode[] a = _list_a == null ? new JSNode[]{} : _list_a.toArray(new JSNode[_list_a.size()]);
                return new JSArgumentsNode(a);
            }
            case 222: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 223: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 229: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol o = this._symbols[offset + 2];
                return new JSPostUnaryOperatorNode(o, e);
            }
            case 231: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol o = this._symbols[offset + 2];
                return new JSPostUnaryOperatorNode(o, e);
            }
            case 235: {
                Symbol o = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSPreUnaryOperatorNode(o, e);
            }
            case 237: {
                Symbol o = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSPreUnaryOperatorNode(o, e);
            }
            case 248: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 250: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 255: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 257: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 261: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 263: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 268: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 270: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 272: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 281: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 283: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 285: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 290: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 292: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 294: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 296: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 298: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 300: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 302: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 304: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 306: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 308: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 310: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 312: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 314: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 316: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 318: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 321: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                Symbol _symbol_f = this._symbols[offset + 5];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSConditionalNode(l, q, t, c, f);
            }
            case 323: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                Symbol _symbol_f = this._symbols[offset + 5];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSConditionalNode(l, q, t, c, f);
            }
            case 325: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                Symbol _symbol_f = this._symbols[offset + 5];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSConditionalNode(l, q, t, c, f);
            }
            case 327: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSAssignmentNode(l, o, r);
            }
            case 329: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSAssignmentNode(l, o, r);
            }
            case 331: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSAssignmentNode(l, o, r);
            }
            case 344: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSCommaNode(l, r);
            }
            case 346: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSCommaNode(l, r);
            }
            case 348: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSCommaNode(l, r);
            }
            case 350: {
                Symbol n = this._symbols[offset + 1];
                return new JSNullNode(n);
            }
            case 351: {
                Symbol t = this._symbols[offset + 1];
                return new JSTrueNode(t);
            }
            case 352: {
                Symbol f = this._symbols[offset + 1];
                return new JSFalseNode(f);
            }
            case 353: {
                Symbol n = this._symbols[offset + 1];
                return new JSNumberNode(n);
            }
            case 354: {
                Symbol s = this._symbols[offset + 1];
                return new JSStringNode(s);
            }
            case 355: {
                Symbol r = this._symbols[offset + 1];
                return new JSRegexNode(r);
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 169: 
            case 170: 
            case 173: 
            case 174: 
            case 198: 
            case 199: 
            case 200: 
            case 204: 
            case 208: 
            case 210: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 230: 
            case 232: 
            case 233: 
            case 234: 
            case 236: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 249: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 256: 
            case 258: 
            case 259: 
            case 260: 
            case 262: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 278: 
            case 279: 
            case 280: 
            case 282: 
            case 284: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 291: 
            case 293: 
            case 295: 
            case 297: 
            case 299: 
            case 301: 
            case 303: 
            case 305: 
            case 307: 
            case 309: 
            case 311: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 320: 
            case 322: 
            case 324: 
            case 326: 
            case 328: 
            case 330: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 345: 
            case 347: 
            case 349: {
                return this._symbols[offset + 1];
            }
        }
        throw new IllegalArgumentException("unknown production #" + rule_num);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JSEvents
    extends Parser.Events {
        private JSEvents() {
        }

        public void scannerError(Scanner.Exception e) {
        }

        public void syntaxError(Symbol token) {
            if (token != null && JSParser.this.fWorking != null) {
                JSParser.this.fWorking.addError((IParseError)new ParseError("com.aptana.contenttype.js", token, IProblem.Severity.ERROR));
            }
        }

        public void unexpectedTokenRemoved(Symbol token) {
        }

        public void missingTokenInserted(Symbol token) {
        }

        public void missingTokensInserted(List<Symbol> tokens) {
            if (tokens != null && tokens.size() == 1 && tokens.get(0).getId() == 25 && JSParser.this.fWorking != null) {
                IParseError lastError;
                List errors = JSParser.this.fWorking.getErrors();
                IParseError iParseError = lastError = errors.isEmpty() ? null : (IParseError)errors.get(errors.size() - 1);
                if (lastError != null) {
                    JSParser.this.fWorking.removeError(lastError);
                }
            }
            super.missingTokensInserted(tokens);
        }

        public void misspelledTokenReplaced(Symbol token) {
        }

        public void errorPhraseRemoved(Symbol error) {
        }
    }
}

